using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;

class Program
{
    static void Main()
    {
        var prviRed = Console.ReadLine().Trim().Split();
        int brojTacki = int.Parse(prviRed[0]);
        double eps = double.Parse(prviRed[1], CultureInfo.InvariantCulture);

        double[] x = new double[brojTacki];
        double[] y = new double[brojTacki];

        for (int i = 0; i < brojTacki; i++)
        {
            var delovi = Console.ReadLine().Trim().Split();
            x[i] = double.Parse(delovi[0], CultureInfo.InvariantCulture);
            y[i] = double.Parse(delovi[1], CultureInfo.InvariantCulture);
        }
        double stranica = eps / 2.0;
        var mapaCelija = new Dictionary<(int, int), int>();
        for (int i = 0; i < brojTacki; i++)
        {
            int cx = (int)Math.Floor(x[i] / stranica);
            int cy = (int)Math.Floor(y[i] / stranica);
            var key = (cx, cy);
            if (!mapaCelija.ContainsKey(key))
                mapaCelija[key] = i;
        }
        var Q = mapaCelija.Values.ToList();
        Q.Sort((i1, i2) =>
        {
            int cmp = (x[i1] + y[i1]).CompareTo(x[i2] + y[i2]);
            if (cmp != 0) return cmp;
            return i1.CompareTo(i2);
        });

        int k = Q.Count;
        Console.WriteLine(k);
        var izlazIndeksi = Q.Select(idx => (idx + 1).ToString());
        Console.WriteLine(string.Join(" ", izlazIndeksi));
        for (int i = 1; i < k; i++)
        {
            int a = Q[0] + 1;
            int b = Q[i] + 1; 
            Console.WriteLine($"{a} {b}");
        }
    }
}